<?php 
session_start();
ob_start(); // Start output buffering
include 'db.php';
include 'header.php';

// Check if the admin is logged in
if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: admin_login.php');
    exit();
}

// Fetch all documents
$query = "SELECT * FROM documents";
$result = mysqli_query($conn, $query);

// Check if the query was successful
if (!$result) {
    die("Database query failed: " . mysqli_error($conn));
}

// Handle search functionality
$search = '';
if (isset($_POST['search'])) {
    $search = mysqli_real_escape_string($conn, $_POST['search']);
    $query = "SELECT * FROM documents WHERE name LIKE '%$search%' OR father_name LIKE '%$search%' OR cnic_no LIKE '%$search%' OR reference_no LIKE '%$search%'";
    $result = mysqli_query($conn, $query);

    // Check if the query was successful
    if (!$result) {
        die("Database search query failed: " . mysqli_error($conn));
    }
}

// Handle delete functionality
if (isset($_GET['delete_id'])) {
    $delete_id = intval($_GET['delete_id']);
    $delete_query = "DELETE FROM documents WHERE id = $delete_id";
    mysqli_query($conn, $delete_query);
    header("Location: admin_dashboard.php"); // Redirect after deletion
    exit();
}

// Handle QR code download
if (isset($_GET['download_qr_id'])) {
    $download_qr_id = intval($_GET['download_qr_id']);
    $query = "SELECT reference_no FROM documents WHERE id = $download_qr_id";
    $result_qr = mysqli_query($conn, $query);
    
    if ($result_qr && mysqli_num_rows($result_qr) > 0) {
        $row_qr = mysqli_fetch_assoc($result_qr);
        $reference_no = $row_qr['reference_no'];

        // Path to the QR code file
        $qr_file = 'qrcodes/' . $reference_no . '.png';

        // Check if the file exists
        if (file_exists($qr_file)) {
            // Clear output buffer to avoid corrupted downloads
            ob_clean();
            flush();

            // Set headers to force the download
            header('Content-Description: File Transfer');
            header('Content-Type: application/octet-stream');
            header('Content-Disposition: attachment; filename="' . basename($qr_file) . '"');
            header('Expires: 0');
            header('Cache-Control: must-revalidate');
            header('Pragma: public');
            header('Content-Length: ' . filesize($qr_file));
            readfile($qr_file);
            exit();
        } else {
            // File doesn't exist, handle error
            echo "<script>alert('QR code not found.');</script>";
        }
    } else {
        echo "<script>alert('No record found for the provided ID.');</script>";
    }
}

ob_end_flush(); // Flush the output buffer and turn off output buffering
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document Verification System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <style>
        /* Your styles here */
        
        body {
            background-color: #f8f9fa;
        }
        h1 {
            color: #4CAF50; /* Success color for heading */
            margin-top: 100px;
        }
        .table th {
            background-color: #4CAF50; /* Success color for table header */
            color: white;
        }
        .btn-view {
            background-color: #28a745; /* Green for View */
            color: white;
            font-size: 0.75rem; /* Smaller font size */
        }
        .btn-view:hover {
            background-color: #218838; /* Darker green on hover */
        }
        .btn-qr {
            background-color: #ffc107; /* Yellow for QR Code */
            color: black;
            font-size: 0.75rem; /* Smaller font size */
        }
        .btn-qr:hover {
            background-color: #e0a800; /* Darker yellow on hover */
        }
        .btn-danger {
            background-color: #dc3545; /* Red for Delete */
            color: white;
            font-size: 0.75rem; /* Smaller font size */
        }
        .btn-danger:hover {
            background-color: #c82333; /* Darker red on hover */
        }
        .search-bar {
            position: relative;
        }
        .search-bar input {
            padding-right: 40px; /* Space for the search button */
        }
        .search-bar .btn {
            position: absolute;
            right: 0;
            top: 0;
            height: 100%;
            border-radius: 0 .25rem .25rem 0; /* Rounded corners on the right */
        }
        /* Status background colors */
        .status-pending {
            background-color: blue; /* Background color for Pending status */
            color: white; /* Text color */
            font-weight: bold; /* Bold text */
            padding: 2px 5px; /* Padding for better appearance */
            border-radius: 4px; /* Rounded corners */
        }
        .status-draft {
            background-color: yellow; /* Background color for Draft status */
            color: black; /* Text color */
            font-weight: bold; /* Bold text */
            padding: 2px 5px; /* Padding for better appearance */
            border-radius: 4px; /* Rounded corners */
        }
        .status-completed {
            background-color: green; /* Background color for Completed status */
            color: white; /* Text color */
            font-weight: bold; /* Bold text */
            padding: 2px 5px; /* Padding for better appearance */
            border-radius: 4px; /* Rounded corners */
        }
    
    </style>
</head>
<body>
    <div class="container mt-5">
        <h1 class="text-center mb-4">Document Verification System</h1>

        <form method="POST" class="mb-4 search-bar">
            <input type="text" name="search" class="form-control" placeholder="Search by Name, Father's Name, CNIC, or Reference Number" value="<?= htmlspecialchars($search) ?>">
            <button class="btn btn-outline-secondary" type="submit">Search</button>
        </form>

        <div class="d-flex justify-content-between mb-3">
            <a href="add_document.php" class="btn btn-primary">Add New Document</a>
            <div>
                <a href="#" class="btn btn-info">Profile</a> <!-- Profile button -->
                <a href="logout.php" class="btn btn-danger">Logout</a> <!-- Logout button -->
            </div>
        </div>
        
        <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>SR</th>
                        <th>Name</th>
                        <th>Father's Name</th>
                        <th>CNIC No</th>
                        <th>Reference No</th>
                        <th>Mobile No</th>
                        <th>Address</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $sr = 1; while ($row = mysqli_fetch_assoc($result)): ?>
                        <tr>
                            <td><?= $sr++ ?></td>
                            <td><?= htmlspecialchars($row['name']) ?></td>
                            <td><?= htmlspecialchars($row['father_name']) ?></td>
                            <td><?= htmlspecialchars($row['cnic_no']) ?></td>
                            <td><?= htmlspecialchars($row['reference_no']) ?></td>
                            <td><?= htmlspecialchars($row['mobile_no']) ?></td>
                            <td><?= htmlspecialchars($row['address']) ?></td>
                            <td>
                                <?php
                                // Display status with background color coding
                                $status = htmlspecialchars($row['status']);
                                if ($status === 'Pending') {
                                    echo "<span class='status-pending'>$status</span>";
                                } elseif ($status === 'Draft') {
                                    echo "<span class='status-draft'>$status</span>";
                                } elseif ($status === 'Completed') {
                                    echo "<span class='status-completed'>$status</span>";
                                } else {
                                    echo $status; // Fallback for any other status
                                }
                                ?>
                            </td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="view_document.php?id=<?= $row['id'] ?>" class="btn btn-view btn-sm">View</a>
                                    <a href="?download_qr_id=<?= $row['id'] ?>" class="btn btn-qr btn-sm">QR</a>
                                    <a href="?delete_id=<?= $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this document?');">Delete</a>
                                </div>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>

