<?php
session_start();
include 'db.php';

// Initialize error variable
$error = '';

// Check if the form is submitted
if (isset($_POST['login'])) {
    $username_or_email = trim($_POST['username']); // Now it can be either username or email
    $password = $_POST['password'];

    // Prepare SQL statement to check for either username or email
    $stmt = $conn->prepare("SELECT id, username, password FROM admins WHERE username = ? OR email = ?");

    if ($stmt === false) {
        die("Error preparing statement: " . $conn->error);
    }

    $stmt->bind_param("ss", $username_or_email, $username_or_email); // Bind the same variable for both username and email
    $stmt->execute();
    $stmt->store_result(); // Store the result set

    // Check if user exists
    if ($stmt->num_rows > 0) {
        $stmt->bind_result($fetched_id, $fetched_username, $fetched_password); // Bind the result variables
        $stmt->fetch(); // Fetch the results

        // Verify the password
        if (password_verify($password, $fetched_password)) {
            // Store session variables
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_id'] = $fetched_id; // Store admin ID in the session
            header('Location: admin_dashboard.php');
            exit(); // Always call exit after header redirect
        } else {
            $error = "Invalid username, email, or password!";
        }
    } else {
        $error = "Invalid username, email, or password!";
    }

    $stmt->close();
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Login</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-image: url('https://upload.wikimedia.org/wikipedia/commons/f/fa/Faisal_Masjid_From_Damn_e_koh.jpg');
            background-size: cover;
            background-position: center;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            position: relative;
        }
        .overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 1;
        }
        .login-box {
            background: rgba(255, 255, 255, 0.8);
            padding: 30px;
            border-radius: 10px;
            z-index: 2;
            width: 400px;
            text-align: center;
        }
        .login-box h2 {
            color: #4CAF50; /* Success color for heading */
        }
        .form-control {
            background-color: #f8f9fa;
            color: #000; /* Black color for text */
        }
        .form-control::placeholder {
            color: #6c757d; /* Grey color for placeholder */
        }
        .btn-primary {
            background-color: #4CAF50; /* Success color for button */
            border-color: #4CAF50;
        }
        .btn-primary:hover {
            background-color: #45a049; /* Darker success color on hover */
        }
        .form-label {
            color: #000; /* Black color for labels */
        }
    </style>
</head>
<body>
    <div class="overlay"></div>
    <div class="login-box">
        <h2>MNSV Verification System</h2>
        <?php if (!empty($error)): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>
        <form method="POST">
            <div class="mb-3">
                <label for="username" class="form-label">Username</label>
                <input type="text" class="form-control" name="username" placeholder="Enter username" required>
            </div>
            <div class="mb-3">
                <label for="password" class="form-label">Password</label>
                <input type="password" class="form-control" name="password" placeholder="Enter password" required>
            </div>
            <button type="submit" name="login" class="btn btn-primary">Login</button>
        </form>
    </div>
</body>
</html>
