<?php
session_start();
include 'db.php';

// Handle form submission for verification
$document_info = null;
$files = [];
$verification_status = '';

// Check if ref_no is in the URL
if (isset($_GET['ref_no'])) {
    $reference_no = $_GET['ref_no'];

    // Fetch the document based on Reference No
    $query = "SELECT * FROM documents WHERE reference_no = '$reference_no'";
    $result = mysqli_query($conn, $query);

    if (!$result) {
        die("Query failed: " . mysqli_error($conn)); // Display the error
    }

    if (mysqli_num_rows($result) > 0) {
        $document_info = mysqli_fetch_assoc($result);
        $verification_status = 'Verified'; // Document found

        // Fetch associated files from the attachment field
        if ($document_info['attachment']) {
            $files = explode(',', $document_info['attachment']); // Split the attachments into an array
        }
    } else {
        $verification_status = 'Document not found'; // No document found
    }
}

// Handle form submission for manual verification
if (isset($_POST['verify'])) {
    $reference_no = $_POST['reference_no'];

    // Fetch the document based on Reference No
    $query = "SELECT * FROM documents WHERE reference_no = '$reference_no'";
    $result = mysqli_query($conn, $query);

    if (!$result) {
        die("Query failed: " . mysqli_error($conn)); // Display the error
    }

    if (mysqli_num_rows($result) > 0) {
        $document_info = mysqli_fetch_assoc($result);
        $verification_status = 'Verified'; // Document found

        // Fetch associated files from the attachment field
        if ($document_info['attachment']) {
            $files = explode(',', $document_info['attachment']); // Split the attachments into an array
        }
    } else {
        $verification_status = 'Document not found'; // No document found
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>User Verification</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</head>
<body>
    <div class="container mt-5">
        <h1 class="text-center">Document Verification</h1>
        
        <form method="POST" class="mb-4">
            <div class="mb-3">
                <label for="reference_no" class="form-label">Enter Reference No</label>
                <input type="text" class="form-control" name="reference_no" required>
            </div>
            <button type="submit" name="verify" class="btn btn-primary">Verify</button>
        </form>

        <?php if ($verification_status): ?>
            <?php if ($document_info): ?>
                <div class="alert alert-success" role="alert">
                    Document Verified Successfully!
                </div>
                <h2 class="mt-5">Document Details</h2>
                <p><strong>Reference No:</strong> <?= htmlspecialchars($document_info['reference_no']) ?></p>
                <p><strong>Name:</strong> <?= htmlspecialchars($document_info['name']) ?></p>
                <p><strong>Father's Name:</strong> <?= htmlspecialchars($document_info['father_name']) ?></p>
                <p><strong>CNIC No:</strong> <?= htmlspecialchars($document_info['cnic_no']) ?></p>
                <p><strong>Mobile No:</strong> <?= htmlspecialchars($document_info['mobile_no']) ?></p>
                <p><strong>Address:</strong> <?= htmlspecialchars($document_info['address']) ?></p>
                <p><strong>Document Type:</strong> <?= htmlspecialchars($document_info['document_type']) ?></p>

                <h2 class="mt-5">Associated Files</h2>
                <ul class="list-group">
                    <?php if (!empty($files)): ?>
                        <?php foreach ($files as $index => $file): ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?= ($index + 1) . '. ' . htmlspecialchars($file) ?>
                                <a href="download.php?file=<?= urlencode(htmlspecialchars($file)) ?>" target="_blank" class="btn btn-success btn-sm">View</a>
                            </li>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <li class="list-group-item">No files associated with this reference number.</li>
                    <?php endif; ?>
                </ul>
            <?php else: ?>
                <div class="alert alert-danger" role="alert">
                    Document Not Found!
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</body>
</html>
