<?php
include 'db.php';

if (isset($_POST['cnic_no'])) {
    // Sanitize input to prevent SQL injection
    $cnic_no = mysqli_real_escape_string($conn, $_POST['cnic_no']);
    
    // Query to fetch user details based on CNIC
    $query = "SELECT name, father_name, mobile_no, address FROM documents WHERE cnic_no = '$cnic_no'";
    $result = mysqli_query($conn, $query);
    
    if ($result) {
        if (mysqli_num_rows($result) > 0) {
            // User found, fetch details
            $userDetails = mysqli_fetch_assoc($result);
            echo json_encode(['success' => true] + $userDetails);
        } else {
            // No user found
            echo json_encode(['success' => true, 'name' => '', 'father_name' => '', 'mobile_no' => '', 'address' => '']);
        }
    } else {
        // Query error, output the error message
        echo json_encode(['success' => false, 'message' => 'Database query error: ' . mysqli_error($conn)]);
    }
} else {
    // CNIC not provided
    echo json_encode(['success' => false, 'message' => 'CNIC number not provided.']);
}
?>
