<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <style>
        body {
            margin: 0;
            font-family: 'Roboto', sans-serif;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background-color: white;
            padding: 10px 20px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            position: fixed;
            width: 100%;
            top: 0;
            z-index: 1000;
        }
        .logo img {
            height: 50px;
        }
        .nav {
            display: flex;
            justify-content: center;
            gap: 20px;
            flex: 1;
        }
        .nav a {
            color: #000;
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s;
        }
        .nav a:hover {
            color: #007bff;
        }
        /* Responsive Menu */
        @media (max-width: 768px) {
            .nav {
                display: none; /* Hide nav by default */
            }
            .menu-toggle {
                display: block;
                cursor: pointer;
                color: #000;
                font-size: 24px;
                margin-left: auto;
            }
        }
        /* Menu toggle display */
        .menu {
            display: none; /* Hide menu initially */
            flex-direction: column;
            background-color: white;
            position: absolute;
            top: 60px; /* Adjust based on header height */
            right: 0;
            width: 100%;
            padding: 10px 0;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
        }
        .menu a {
            padding: 10px 20px;
            display: block;
            text-align: center;
            color: #000; /* Black text for menu */
        }
        .menu.active {
            display: flex; /* Show menu when active */
        }
    </style>
</head>
<body>

<div class="header">
    <div class="logo">
        <a href="https://mnsvtranslator.com">
            <img src="https://mnsvtranslator.com/wp-content/uploads/2020/01/ATgRz4zC.png" alt="Logo">
        </a>
    </div>
    <div class="nav">
        <a href="https://mnsvtranslator.com/">Home</a>
        <a href="https://mnsvtranslator.com/our-services/">Our Services</a>
        <a href="https://mnsvtranslator.com/pricing/">Pricing</a>
        <a href="https://mnsvtranslator.com/translation-guide/">Translation Guide</a>
        <a href="https://mnsvtranslator.com/order-now/">Order Now</a>
        <a href="https://mnsvtranslator.com/contact-us/">Contact Us</a>
    </div>
    <div class="menu-toggle" onclick="toggleMenu()">&#9776;</div> <!-- Hamburger menu icon -->
</div>

<div class="menu" id="menu">
    <a href="https://mnsvtranslator.com/">Home</a>
    <a href="https://mnsvtranslator.com/our-services/">Our Services</a>
    <a href="https://mnsvtranslator.com/pricing/">Pricing</a>
    <a href="https://mnsvtranslator.com/translation-guide/">Translation Guide</a>
    <a href="https://mnsvtranslator.com/order-now/">Order Now</a>
    <a href="https://mnsvtranslator.com/contact-us/">Contact Us</a>
</div>

<script>
    function toggleMenu() {
        const menu = document.getElementById('menu');
        menu.classList.toggle('active');
    }

    // Show or hide the hamburger menu based on window width
    function checkWidth() {
        const menuToggle = document.querySelector('.menu-toggle');
        const menu = document.getElementById('menu');

        if (window.innerWidth <= 768) {
            menuToggle.style.display = 'block'; // Show hamburger menu on mobile
        } else {
            menuToggle.style.display = 'none'; // Hide hamburger menu on desktop
            menu.classList.remove('active'); // Close the menu if it's open
        }
    }

    window.addEventListener('resize', checkWidth);
    window.addEventListener('load', checkWidth);
</script>

</body>
</html>
