<?php
// Start the session
session_start();

// Destroy the session to log the user out
session_destroy();
// Include the header
include 'header.php'; // Include your header here

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Logout</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            background-image: url('https://upload.wikimedia.org/wikipedia/commons/f/fa/Faisal_Masjid_From_Damn_e_koh.jpg');
            background-size: cover; /* Cover the entire viewport */
            background-position: center; /* Center the background image */
        }
        .logout-container {
            background-color: white; /* White background for the box */
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            text-align: center;
            animation: fadeIn 1s ease-in-out;
        }
        h1 {
            color: #dc3545; /* Red color for sadness */
            margin-bottom: 20px;
        }
        p {
            color: #28a745; /* Green color for branding */
            margin-bottom: 30px;
            font-size: 1.2em;
        }
        .sad-animation {
            width: 100px;
            height: 100px;
            margin: 0 auto;
            position: relative;
        }
        .sad-face {
            background-color: #007bff; /* Blue face */
            border-radius: 50%;
            position: relative;
            width: 100%;
            height: 100%;
        }
        .sad-eye {
            background-color: #fff;
            border-radius: 50%;
            width: 20px;
            height: 20px;
            position: absolute;
            top: 25px;
        }
        .sad-eye.left {
            left: 25%;
        }
        .sad-eye.right {
            right: 25%;
        }
        .sad-mouth {
            width: 40px;
            height: 20px;
            border: 5px solid white;
            border-top-left-radius: 20px;
            border-top-right-radius: 20px;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(180deg); /* Upside down mouth */
        }
        .tear {
            background-color: #28a745; /* Green for tears */
            border-radius: 50%;
            width: 10px;
            height: 20px;
            position: absolute;
            animation: drop 1s infinite;
        }
        .tear.left {
            left: 30%;
            animation-delay: 0s;
        }
        .tear.right {
            right: 30%;
            animation-delay: 0.5s;
        }
        @keyframes drop {
            0% { top: 25px; opacity: 1; }
            50% { top: 50px; opacity: 1; }
            100% { top: 70px; opacity: 0; }
        }
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
    </style>
</head>
<body>
    <div class="logout-container">
        <h1>We're Sad to See You Go...</h1>
        <p>Thank you for being with us. We hope to see you again soon!</p>
        <div class="sad-animation">
            <div class="sad-face">
                <div class="sad-eye left"></div>
                <div class="sad-eye right"></div>
                <div class="sad-mouth"></div>
                <div class="tear left"></div>
                <div class="tear right"></div>
            </div>
        </div>
    </div>

    <script>
        // Redirect to login page after 4 seconds
        setTimeout(function() {
            window.location.href = 'admin_login.php'; // Change to your login page
        }, 4000);
    </script>
</body>
</html>
